/*:
 * @target MZ
 * @plugindesc 
 * [RPG Maker MZ] [v1.1] Remember Choice Cursor Position (Optimized)
 * @author Elle Trudgett (Optimized)
 * @url https://forums.rpgmakerweb.com/index.php?threads/show-choices-cursor-memory.153841/
 * @help
 * This plugin allows your game to remember the cursor position in the
 * [Show Choices] command window.
 *
 * Useful for when you have many options the player can choose in a
 * [Loop] and you don't want them to have to scroll down from the top
 * after each selection.
 * 
 * Optimization improvements:
 * - Removed executeCommand overhead for better performance
 * - Simplified memory storage using Map data structure
 * - Added automatic cleanup to prevent memory leaks
 */

var RCCP = RCCP || {};
RCCP.ChoiceMemory = new Map();

// Extend Window_ChoiceList to remember cursor position
((_) => {
    const _selectDefault = _.selectDefault;
    
    _.selectDefault = function() {
        _selectDefault.call(this);
        
        const interpreter = $gameMap._interpreter;
        if (!interpreter) return;
        
        const key = `${$gameMap._mapId}_${interpreter._eventId}_${interpreter._index}`;
        const savedIndex = RCCP.ChoiceMemory.get(key);
        
        if (savedIndex !== undefined && savedIndex < this.maxItems()) {
            this.select(savedIndex);
        }
    };
    
    const _callOkHandler = _.callOkHandler;
    
    _.callOkHandler = function() {
        _callOkHandler.call(this);
        
        const interpreter = $gameMap._interpreter;
        if (!interpreter) return;
        
        const key = `${$gameMap._mapId}_${interpreter._eventId}_${interpreter._index}`;
        RCCP.ChoiceMemory.set(key, this.index());
    };
    
})(Window_ChoiceList.prototype);

// Extend Scene_Map to clean up memory on map change
((_) => {
    const _onMapLoaded = _.onMapLoaded;
    
    _.onMapLoaded = function() {
        _onMapLoaded.call(this);
        
        const currentMapId = $gameMap._mapId;
        for (const key of RCCP.ChoiceMemory.keys()) {
            if (!key.startsWith(`${currentMapId}_`)) {
                RCCP.ChoiceMemory.delete(key);
            }
        }
    };
    
})(Scene_Map.prototype);